import matplotlib.pyplot as plt
import matplotlib.patches as patches

# Create a figure and axis
fig, ax = plt.subplots(figsize=(8, 10))

# Define the grid size
rows, cols = 5, 4

# Define the colors for tiles
clear_color = 'lightgreen'
not_clear_color = 'salmon'
white_paint_color = 'white'
black_paint_color = 'black'

# Define the goal tile colors
goal_tile_colors = {
    'tile_1-1': white_paint_color, 'tile_1-2': black_paint_color, 'tile_1-3': white_paint_color, 'tile_1-4': black_paint_color,
    'tile_2-1': black_paint_color, 'tile_2-2': white_paint_color, 'tile_2-3': black_paint_color, 'tile_2-4': white_paint_color,
    'tile_3-1': white_paint_color, 'tile_3-2': black_paint_color, 'tile_3-3': white_paint_color, 'tile_3-4': black_paint_color,
    'tile_4-1': black_paint_color, 'tile_4-2': white_paint_color, 'tile_4-3': black_paint_color, 'tile_4-4': white_paint_color,
    'tile_0-1': clear_color, 'tile_0-2': clear_color, 'tile_0-3': clear_color, 'tile_0-4': clear_color,
}

# Draw the tiles
for row in range(rows):
    for col in range(cols):
        tile_id = f'tile_{row}-{col+1}'
        color = goal_tile_colors[tile_id]
        rect = patches.Rectangle((col, rows-row-1), 1, 1, linewidth=1, edgecolor='black', facecolor=color)
        ax.add_patch(rect)
        ax.text(col + 0.5, rows-row-0.5, tile_id, ha='center', va='center', fontsize=8, color='black')

# Draw the robots at the bottom
robot_positions = {
    'robot1': (0, -1),
    'robot2': (1, -1),
}

for robot, (col, row) in robot_positions.items():
    color = white_paint_color if robot == 'robot1' else black_paint_color
    circle = patches.Circle((col + 0.5, row - 0.5), 0.3, edgecolor='black', facecolor=color)
    ax.add_patch(circle)
    ax.text(col + 0.5, row - 0.7, robot, ha='center', va='center', fontsize=8, color='black' if color == 'white' else 'white')

# Set limits and labels
ax.set_xlim(-1, cols)
ax.set_ylim(-2, rows)
ax.set_xticks([])
ax.set_yticks([])

# Add legend
legend_elements = [
    patches.Patch(facecolor=white_paint_color, edgecolor='black', label='White Painted Tile'),
    patches.Patch(facecolor=black_paint_color, edgecolor='black', label='Black Painted Tile'),
    patches.Patch(facecolor=clear_color, edgecolor='black', label='Clear Tile'),
    patches.Patch(facecolor=white_paint_color, edgecolor='black', label='Robot1 (White)'),
    patches.Patch(facecolor=black_paint_color, edgecolor='black', label='Robot2 (Black)'),
]
ax.legend(handles=legend_elements, loc='upper right', bbox_to_anchor=(1.3, 1))

# Save the figure
plt.savefig('tiles/one_shot/goal_diagram_code/attempts/goal_diagram_attempt_3.png', bbox_inches='tight')
plt.show()
# VERIFICATION FAILED:
# Robots are not positioned on row 0 as required in the goal state.
